// C Source File
// Created 3/5/2005; 9:53:01 AM

#include <tigcclib.h>
#include "extgraph.h"

#include "BasicTypes.h"
#include "GrayUtils.h"

unsigned char* PLANE_CurrentPlane0  = 0;
unsigned char* PLANE_CurrentPlane1  = 0;
unsigned char* PLANE_PreviousPlane0 = 0;
unsigned char* PLANE_PreviousPlane1 = 0;

unsigned char* PLANE_Plane0 = 0;
unsigned char* PLANE_Plane1 = 0;
unsigned char* PLANE_Plane2 = 0;
unsigned char* PLANE_Plane3 = 0;

void* DoubleBuffer = 0;
INT_HANDLER saveInt1;
INT_HANDLER saveInt5;

StatusType GrayScaleOn()
{
	DoubleBuffer = 0;

	saveInt1 = GetIntVec (AUTO_INT_1);
	saveInt5 = GetIntVec (AUTO_INT_5);

	// This saves the interrupt vector 1
	SetIntVec (AUTO_INT_1, DUMMY_HANDLER);   // redirect auto-int 1 to "nothing"
	SetIntVec (AUTO_INT_5, DUMMY_HANDLER);   // redirect auto-int 5 to "nothing"

	if (GrayOn ())
	{
		PLANE_Plane0 = GrayGetPlane(DARK_PLANE);
		PLANE_Plane1 = GrayGetPlane(LIGHT_PLANE);

		PLANE_CurrentPlane0  = PLANE_Plane0;
		PLANE_CurrentPlane1  = PLANE_Plane1;

		DoubleBuffer = malloc(GRAYDBUFFER_SIZE);

		if (!DoubleBuffer)
		{
			GrayOff();
			return Failed;
		}

		GrayDBufInit(DoubleBuffer);
		GrayDBufToggleSync();

		PLANE_Plane2 = (unsigned char*)GrayDBufGetPlane(1,DARK_PLANE);
		PLANE_Plane3 = (unsigned char*)GrayDBufGetPlane(1,LIGHT_PLANE);

		PLANE_PreviousPlane0 = PLANE_Plane2;
		PLANE_PreviousPlane1 = PLANE_Plane3;

		return Success;
	}

	return Failed;
}

void GrayFillScreen(int2 color)
{
	GraySetScreenColor_R(color, PLANE_CurrentPlane0, PLANE_CurrentPlane1);
}

void SwapPlaneBuffers(void)
{
	if (DoubleBuffer)
	{
		// sync prior to toggling the double plane buffers to minimize flickering
		GrayDBufToggleSync();

		// toggle the double plane buffers
		if (PLANE_CurrentPlane0 == PLANE_Plane0)
		{
			PLANE_CurrentPlane0  = PLANE_Plane2;
			PLANE_CurrentPlane1  = PLANE_Plane3;
			PLANE_PreviousPlane0 = PLANE_Plane0;
			PLANE_PreviousPlane1 = PLANE_Plane1;
		}
		else
		{
			PLANE_CurrentPlane0  = PLANE_Plane0;
			PLANE_CurrentPlane1  = PLANE_Plane1;
			PLANE_PreviousPlane0 = PLANE_Plane2;
			PLANE_PreviousPlane1 = PLANE_Plane3;
		}
	}
}

StatusType GrayScaleOff()
{
	GrayOff();

	if (DoubleBuffer)
		free(DoubleBuffer);

	SetIntVec (AUTO_INT_1, saveInt1);
	SetIntVec (AUTO_INT_5, saveInt5);

	return Success;
}
